/**
* \file: MediaAudioChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for media playback
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_MEDIAAUDIOCHANNEL_H
#define BDCL_MEDIAAUDIOCHANNEL_H

#include <bdcl/AditAudioSink.h>

namespace adit { namespace bdcl {

class MediaAudioChannel : public IAditAudioSinkCallbacks
{
public:
    MediaAudioChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~MediaAudioChannel();

private:
    AditAudioSink* mAudioSink;

    /** @brief Callback initiated by Baidu core to initialize and start audio playback. The input parameters must be
     *         used to configure the audio device with each starting stream.
     */
    void onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat);

    /** @brief Callback initiated by Baidu core to stop audio playback.
     */
    void onPlaybackStop();

    /** @brief Callback initiated by Baidu core to resume audio playback. Resume callback is only relevant for media
     *         channel.
     */
    void onPlaybackResume();

    /** @brief Callback initiated by Baidu core to pause audio playback. Pause callback is only relevant for media
     *         channel.
     */
    void onPlaybackPause();

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_MEDIAAUDIOCHANNEL_H */
